<?xml version="1.0" encoding="UTF-8"?>

<ModuleContainer version="4">
   <modules>
      <module name="CommentModule">
         <parameters>
            <parameter name="Active">true</parameter>
            <parameter name="GroupStart">true</parameter>
            <parameter name="GroupCollapsed">false</parameter>
            <parameter name="LineBreak">true</parameter>
            <parameter name="VerticalSpace">10</parameter>
            <parameter name="Label">School detection</parameter>
            <parameter name="Comment">The modules between TemporaryComputationsBeginModule and TemporaryComputationsEndModule do school detection.
All calculations between "Temporary computations begin" and "Temporary computations end" are discarded after "Temporary computations end", but any new datagrams 
are kept - in this case the datagram generated by "School detection". 
- The module "Thresholding" is not needed anymore, but was needed due to a bug in old KORONA setups.
- The "Smoother" module improved performance of school detection slightly.
- The "Expression" module creates a new synthetic channel intended for school-detection by combining data from several frequencies
</parameter>
         </parameters>
      </module>
      <module name="TemporaryComputationsBeginModule">
         <parameters>
            <parameter name="Active">true</parameter>
         </parameters>
      </module>
      <module name="SmootherModule">
         <parameters>
            <parameter name="Active">true</parameter>
            <parameter name="Comment">Do some slight smoothing to improve school detection.</parameter>
            <parameter name="OnlyLastChannel">false</parameter>
            <parameter name="MaskPelagic">false</parameter>
            <parameter name="MaskBottom">true</parameter>
            <parameter name="MaskSecondBottom">true</parameter>
            <parameter name="MaskNoise">false</parameter>
            <parameter name="MaskRegion">none</parameter>
            <parameter name="MaskTrack">none</parameter>
            <parameter name="MinPing">0</parameter>
            <parameter name="MaxPing">1</parameter>
            <parameter name="HorizontalKernelType">gaussian</parameter>
            <parameter name="VerticalKernelType">gaussian</parameter>
            <parameter name="HorizontalWidth">3</parameter>
            <parameter name="VerticalWidth">1</parameter>
            <parameter name="LogarithmicValues">false</parameter>
         </parameters>
      </module>
      <module name="ExpressionModule">
         <parameters>
            <parameter name="Active">true</parameter>
            <parameter name="Comment">The ExpressionModule generates a new channel intended for school detection. There are alternative expressions: the first is used if possible, then the next,
and finally the last. The last one is C1 ("channel 1") that always exist. This makes the module setup more portable between ships. F38 means Frequency 38 
kHz. C1 means the first channel. Commonly C1 is 18 kHz that usually has a wider beam than the others. C1 will always exist.</parameter>
            <parameter name="ChannelID">999</parameter>
            <parameter name="Frequency">209000</parameter>
            <parameter name="Expression">
               <value>(F38+F70+6*F200)/8*((3*F200+1E-1)/(F18+F38+F70+1E-1))</value>
               <value>(F38+3*F200)/8*((F200+1E-3)/(F38+1E-3))</value>
               <value>(F38+3*F200)/4</value>
               <value>F38</value>
               <value>C1</value>
            </parameter>
         </parameters>
      </module>
      <module name="SchoolDetectionModule">
         <parameters>
            <parameter name="Active">true</parameter>
            <parameter name="ProcessLast">true</parameter>
            <parameter name="Channel">1</parameter>
            <parameter name="MinDepth">25</parameter>
            <parameter name="MaxDepth"/>
            <parameter name="Threshold">-73</parameter>
            <parameter name="FillHoles">true</parameter>
            <parameter name="FillVerticalGaps">7</parameter>
            <parameter name="FillHorizontalGaps">3</parameter>
            <parameter name="BoundarySmoothingIterations">7</parameter>
            <parameter name="Density">
               <parameter name="min">-65</parameter>
               <parameter name="max">-30</parameter>
            </parameter>
            <parameter name="MaxSv">
               <parameter name="min">-50</parameter>
               <parameter name="max"/>
            </parameter>
            <parameter name="Length">
               <parameter name="min">10</parameter>
               <parameter name="max">1000000</parameter>
            </parameter>
            <parameter name="Thickness">
               <parameter name="min"/>
               <parameter name="max">400</parameter>
            </parameter>
            <parameter name="Area">
               <parameter name="min">100</parameter>
               <parameter name="max">1E7</parameter>
            </parameter>
            <parameter name="Compactness">
               <parameter name="min"/>
               <parameter name="max"/>
            </parameter>
         </parameters>
      </module>
      <module name="TemporaryComputationsEndModule">
         <parameters>
            <parameter name="Active">true</parameter>
         </parameters>
      </module>
      <module name="GroupEndModule">
         <parameters>
            <parameter name="Active">true</parameter>
         </parameters>
      </module>
   </modules>
</ModuleContainer>
